/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TyrusFuture<T>
implements Future<T> {
    private volatile T result;
    private volatile Throwable throwable = null;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit2) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit2)) {
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.result;
        }
        throw new TimeoutException();
    }

    public void setResult(T result2) {
        if (this.latch.getCount() == 1L) {
            this.result = result2;
            this.latch.countDown();
        }
    }

    public void setFailure(Throwable throwable2) {
        if (this.latch.getCount() == 1L) {
            this.throwable = throwable2;
            this.latch.countDown();
        }
    }
}

